/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.tree;

import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.tree.TreeEmptyException;
import com.ibm.hwmca.ui.bonsai.tree.TreeNodeLight;
import com.ibm.psw.wcl.components.tree.AbstractExtendedTreeModel;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreePath;

public class TreeModel
extends AbstractExtendedTreeModel {
    private TreeNodeLight lightRootNode;
    private Locale locale;

    public TreeModel(BonsaiTreeNode rootNode, UISession session, Locale locale) throws TreeEmptyException {
        this.locale = locale;
        this.setData(rootNode, session);
    }

    public void setData(BonsaiTreeNode rootNode, UISession session) throws TreeEmptyException {
        if (!rootNode.isShown(session) || rootNode.isHiddenLeaf()) {
            throw new TreeEmptyException("No nodes in this tree can be displayed to the user!");
        }
        this.lightRootNode = new TreeNodeLight(rootNode, this.locale);
        this.buildLightWeightTree(rootNode, this.lightRootNode, session);
    }

    public String getId() {
        return this.lightRootNode.getId();
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNodeLight)parent).getChildren().get(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNodeLight)parent).getChildren().size();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent != null && child != null) {
            List children = ((TreeNodeLight)parent).getChildren();
            for (int i = 0; i < children.size(); ++i) {
                if (children.get(i) != child) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getRoot() {
        return this.lightRootNode;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private void buildLightWeightTree(BonsaiTreeNode node, TreeNodeLight lwNode, UISession session) {
        BonsaiTreeNode child = null;
        TreeNodeLight lwChild = null;
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            child = (BonsaiTreeNode)iterator.next();
            if (!child.isShown(session) || child.isHiddenLeaf()) continue;
            lwChild = new TreeNodeLight(child, this.locale);
            lwNode.addChild(lwChild);
            this.buildLightWeightTree(child, lwChild, session);
        }
    }
}

